#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//  Plasma BeatMod01.fsh   by    adelciotto   
//https://www.shadertoy.com/view/WtSGRV
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define RETRO_MODE 0

const float RETRO_PIXEL_SIZE = 4.0;
const float PULSE_DURATION = 1.5;
const float PI = 3.1415926535897932384626433832795;
const float TWO_PI = PI * 2.0;

//  function from Iñigo Quiles (no cubic smoothing)
//  https://www.shadertoy.com/view/MsS3Wc
vec3 hsvToRgb(in vec3 c) {
    vec3 rgb = clamp(abs(mod(c.x*6.0+vec3(0.0,4.0,2.0), 6.0)-3.0)-1.0, 0.0, 1.0);
    return c.z * mix(vec3(1.0), rgb, c.y);
}

vec2 rotate(vec2 p, float angle) {
    return vec2(
        cos(angle)*p.x + sin(angle)*p.y,
        -sin(angle)*p.x + cos(angle)*p.y
    );
}

float heart(vec2 p, vec2 center, float size, float angle) {
    vec2 o = (p - center) / (1.6 * size);
    vec2 ro = rotate(o, angle);
    float a = ro.x*ro.x + ro.y*ro.y - 0.3;

    return step(a*a*a * 2.0, ro.x*ro.x * ro.y*ro.y*ro.y);
}

// modified plasma effect from https://www.bidouille.org/prog/plasma
vec3 plasma(vec2 p, float scale) {
    float angle = iTime*0.3;
    vec2 rp = rotate(p, angle);
    rp *= scale;

    float v1 = sin(rp.x+iTime);
    float v2 = sin(rp.y+iTime);
    float v3 = sin(rp.x+rp.y+iTime);
    float v4 = sin(length(rp) + 1.7*iTime);
    float v = v1+v2+v3+v4;

    v *= 2.0;
    vec3 col = vec3(1.0, 0.3-sin(v+PI*.5)*0.2, 0.8 - sin(v+PI*.5)*0.2);
    return col*0.5 + 0.5;
}

vec3 render(vec2 uv, float t) {
    float pulseTime = mod(t, PULSE_DURATION) / PULSE_DURATION;
    float pulseBeat = pow(pulseTime, 0.2) * 0.5 + 0.5;

    float pulse = 1.0 + pulseBeat * 0.5 * sin(pulseTime*TWO_PI*3.0 + uv.y*0.5) * exp(-pulseTime * 4.0);
    vec3 col = plasma(uv, pulse * 8.0);

    // Centre heart.
    float radius = pulse * .4;
    float d = heart(uv, vec2(0, -0.07), radius, 0.0);
    vec3 heartCol = mix(vec3(1.0), vec3(0.95, 0.37, 0.47), pulse);
    col = mix(col, heartCol, d);

    // Rotating heart ring.
    const float piOver6 = PI / 6.0;
    pulse = 0.4 + pulseBeat * 0.3 * sin(pulseTime*TWO_PI*3.0 + uv.x*0.6) * exp(-pulseTime*3.33);
    float ringRadius = 0.25 + pulse;
    for (float angle = piOver6; angle <= TWO_PI; angle += piOver6) {
        float currentAngle = iTime*.8+angle;
        vec2 center = vec2(ringRadius*cos(currentAngle), ringRadius*sin(currentAngle));
        float d = heart(uv, center, 0.08, currentAngle);
        vec3 heartCol = hsvToRgb(vec3((currentAngle / TWO_PI) + 0.5, ringRadius, 1.0));
        col = mix(col, heartCol, d);
    }

    return col;
}

vec2 normalizeScreenCoords(vec2 fragCoord) {
    // Get coordinate in the range -1, 1.
	vec2 result = 2.0 * (fragCoord / iResolution.xy - 0.5);
    
    // Correct for the aspect ratio.
    result.x *= iResolution.x / iResolution.y;
	
    return result;
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    vec2 uv = normalizeScreenCoords(fragCoord);
#if RETRO_MODE
    uv = ceil(uv / retroPixelSize) * retroPixelSize;
#endif
    float t = iTime;
    
    vec3 col = render(uv, iTime);

    fragColor = vec4(col, 1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

